/**
 * MachForm
 * 
 * © 2007–2025 Appnitro Software. All rights reserved.
 * 
 * This source code is proprietary and may not be copied, modified,
 * or distributed in any form without express written permission from Appnitro Software.
 * 
 * License information: https://www.machform.com/license-agreement/
 */

function hide_selection_pane(){
	$("#field_selection").fadeOut('fast');
	$("#entries_actions").fadeIn();
}

function show_selection_pane(){
	$("#filter_pane").hide();
	$("#entries_actions").fadeOut();
	$("#field_selection").fadeIn();	
}

function show_filter_pane(){
	$("#field_selection").hide();
	$("#entries_actions").fadeOut();
	$("#filter_pane").fadeIn();
}

function hide_filter_pane(){
	$("#filter_pane").fadeOut();
	$("#entries_actions").fadeIn();
}


$(function(){
    
	//display the filter pane when 'edit filter being clicked'
	$("#me_edit_filter").on('click',function(){
		show_filter_pane();
		return false;
	});

	//hide the filter pane when the cancel link being clicked
	$("#filter_pane_cancel").on('click',function(){
		hide_filter_pane();
		return false;
	});

	//toggle field selection pane when the 'filter entries' link being clicked
	$("#entry_filter").on('click',function(){
		
		if($("#filter_pane").is(':visible')){
			hide_filter_pane();
		}else{
			show_filter_pane();
		}

		return false;
	});
	
	
	//'apply filter' button being clicked
	$("#me_filter_pane_submit").on('click',function(){
		
		$(this).val("Applying...");
		$(this).prop("disabled",true);
		$("#cancel_filter_pane_span").hide();
		$(this).after("<span id='field_select_loader'><img src='images/loader_small_grey.gif' style='vertical-align: middle;margin-left: 5px'/></span>");
		
		//get filter properties
		var filter_prop_array = new Array();
		$("#filter_pane li.filter_settings").each(function(index){
			filter_prop_array[index] = $(this).data("filter_properties");
		});

		//send to backend using ajax call
		axios.post('save_filter_users.php', {
			filter_prop: filter_prop_array,
			filter_type: $("#filter_all_any").val()
		})
		.then(function (response) {
			if(response.data.status == 'ok'){
				if(response.data.status == 'ok'){
					window.location.replace('manage_users.php');
				}
			}else{
				Swal.fire({
					width: '30%',
					position: 'center',
					icon: 'error',
					title: 'Error. Unable to complete the task.',
					html: response.data,
					showConfirmButton: false,
					showCancelButton: true,
					cancelButtonText: 'Close',
					allowOutsideClick: true
				});
			}
		})
		.catch(function (error) {
			Swal.fire({
				width: '30%',
				position: 'center',
				icon: 'error',
				title: 'Error. Unable to complete the task.',
				html: error,
				showConfirmButton: false,
				showCancelButton: true,
				cancelButtonText: 'Close',
				allowOutsideClick: true
			});
		});
	});

	//attach event to the sort dropdown
	$('#me_sort_by').on('change', function() {
		var sort_element = $(this).val();
		
		window.location.replace('manage_users.php?sortby=' + sort_element);
	});

	//delegate change event into filter field name dropdown
	$('#filter_pane').on('change', 'select.condition_fieldname', function(e) {
			var new_element_name = $(this).val();
			var new_element_type = $("#filter_pane").data(new_element_name);

			$(this).parent().find('.condition_text,.condition_number,.condition_admin,.condition_status,input.text').hide();

			//display the appropriate condition type dropdown, depends on the field type
			//and make sure to update the condition property value when the field type has been changed
			if(new_element_type == 'number'){
				$(this).parent().find('.condition_number,input.text').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_number').val();
			}else if(new_element_type == 'admin'){
				$(this).parent().find('.condition_admin').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_admin').val();
			}else if(new_element_type == 'status'){
				$(this).parent().find('.condition_status').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_status').val();
			}else{
				$(this).parent().find('.condition_text,input.text').show();
				$(this).parent().data('filter_properties').condition = $(this).parent().find('.condition_text').val();
			}

			$(this).parent().data('filter_properties').element_name = new_element_name;
    });

    //delegate change event to the condition type dropdown
    $('#filter_pane').on('change', 'select.condition_text,select.condition_number,select.condition_admin,select.condition_status', function(e) {
		$(this).parent().data('filter_properties').condition = $(this).val();
    });

    //delegate event to the filter keyword text
    $('#filter_pane').on('keyup mouseout change', 'input.text', function(e) {
		$(this).parent().data('filter_properties').keyword = $(this).val();	
    });

    //delegate click event to the delete filter condition icon
    $('#filter_pane').on('click', 'a.filter_delete_a', function(e) {
		
		if($("#filter_pane li:not('.filter_add')").length <= 1){
			Swal.fire({
				title: 'Unable to delete',
				html: `You can't delete all filter conditions! <br/>You must have at least one filter condition.`,
				customClass: {
					title: 'swal2-title-warning',
					htmlContainer: 'swal2-html-container-bold'
				},
				icon: 'error',
				width: '30%',
				allowOutsideClick: true
			});
		}else{
			$(this).parent().fadeOut(function(){
				$(this).remove();
			});
		}

		return false;
    });


	//attach click event to 'add filter condition' icon
	$("#filter_add_a").on('click',function(){
		var new_id = $("#filter_pane li:not('.filter_add')").length + 1;
		var old_id = new_id - 1;
		
		//duplicate the last filter condition
		var last_filter_element = $("#filter_pane ul > li:not('.filter_add')").last();
		last_filter_element.clone(false).data('filter_properties',$.extend('{}',last_filter_element.data('filter_properties'))).find("*[id],*[name]").each(function() {
			var temp = $(this).attr("id").split("_"); 
			var old_id = new_id - 1;

			//rename the original id with the new id
			$(this).attr("id", temp[0] + "_" + new_id);
			$(this).attr("name", temp[0] + "_" + new_id);
			
		}).end().attr("id","li_" + new_id).insertBefore("#li_filter_add").hide().fadeIn();

		//copy the value of the dropdowns
		$("#filterfield_" + new_id).val($("#filterfield_" + old_id).val());
		$("#conditiontext_" + new_id).val($("#conditiontext_" + old_id).val());
		$("#conditionnumber_" + new_id).val($("#conditionnumber_" + old_id).val());
		$("#conditiondate_" + new_id).val($("#conditiondate_" + old_id).val());
		$("#conditionfile_" + new_id).val($("#conditionfile_" + old_id).val());
		$("#conditioncheckbox_" + new_id).val($("#conditioncheckbox_" + old_id).val());
		
		//reset the filter keyword  
		$("#filterkeyword_" + new_id).val('');
		$("#li_" + new_id).data('filter_properties').keyword = '';

		return false;
	});

	//attach click event to 'clear filter' link
	$("#me_clear_filter").on('click',function(){
		if($(this).text() == 'Clear Filter'){
			
			$(this).text('Clearing...');
			$("#filter_info").append("<img src='images/loader_small_grey.gif' style='position: absolute;right: -20px;top:18px'/>");
			
			var csrf_token  = $("#entries_options").data("csrftoken");

			//send to backend using ajax call
			axios.post('clear_filter_users.php', {
				csrf_token: csrf_token
			})
			.then(function (response) {
				if(response.data.status == 'ok'){
					window.location.replace('manage_users.php');
				}else{
					Swal.fire({
						width: '30%',
						position: 'center',
						icon: 'error',
						title: 'Error. Unable to complete the task.',
						html: response.data,
						showConfirmButton: false,
						showCancelButton: true,
						cancelButtonText: 'Close',
						allowOutsideClick: true
					});
				}
			})
			.catch(function (error) {
				Swal.fire({
					width: '30%',
					position: 'center',
					icon: 'error',
					title: 'Error. Unable to complete the task.',
					html: error,
					showConfirmButton: false,
					showCancelButton: true,
					cancelButtonText: 'Close',
					allowOutsideClick: true
				});
			});
		}
	});

	

	//attach event to the "select all entries on this page" checkbox
	$("#col_select").on('click',function(){

		var current_page_entries_total = $("#entries_table tbody > tr").length;
		var all_entries_total = $("#me_entries_total").text();

		var selection_scope = ''
		if($("#filter_info").length > 0){
			selection_scope = 'filtered results';	
		}else{
			selection_scope = 'system'	
		}

		var entries_action_row = '<tr class="entries_select_all"><td colspan="' + $("#entries_table th").length + '">All '+ current_page_entries_total + ' users on this page are selected. <a href="#" id="me_select_all">Select all <strong>'+ all_entries_total +'</strong> users in this '+ selection_scope +'</td></tr>';

		if($(this).prop("checked") == true){
			//select all checkbox
			$("#entries_table input[type='checkbox']:not('#col_select')").prop("checked",true);
			$("#entries_table tr").addClass('me_row_selected');
			$("#entries_table tbody").prepend(entries_action_row);
		}else{
			//deselect all checkbox
			$("#entries_table input[type='checkbox']:not('#col_select')").prop("checked",false);
			$("#entries_table tr.me_row_selected").removeClass('me_row_selected');
			$("#entries_table .entries_select_all").remove();
			$("#col_select").data('full_selection',0);
		}
	});

	//attach event to the "select all entries on this form/filtered results" link
	$("#entries_table").on("click","#me_select_all",function(){

		var all_entries_total = $("#me_entries_total").text();

		var selection_scope = ''
		if($("#filter_info").length > 0){
			selection_scope = 'filtered results';	
		}else{
			selection_scope = 'form'	
		}

		var info_all_selected = 'All ' + all_entries_total + ' entries in this ' + selection_scope + ' are selected. <a id="me_clear_selection" href="#">Clear selection</a>'
		$(".entries_select_all td").html(info_all_selected);

		$("#col_select").data('full_selection',1);

		return false;
	});

	//attach event to the "clear selection" link
	$("#entries_table").on("click","#me_clear_selection",function(){

		$("#entries_table input[type='checkbox']").prop("checked",false);
		$("#entries_table .entries_select_all").remove();
		$("#entries_table tr.me_row_selected").removeClass('me_row_selected');

		$("#col_select").data('full_selection',0);

		return false;
	});

	//attach event to the checkbox of each row
	$("#entries_table input[type='checkbox']:not('#col_select')").on('click',function(){
		if($(this).prop("checked") == true){
			$(this).parent().parent().parent().addClass("me_row_selected");	
		}else{
			$(this).parent().parent().parent().removeClass("me_row_selected");
			$("#entries_table .entries_select_all").remove();
			$("#col_select").prop("checked",false);
			$("#col_select").data('full_selection',0);
		}
	});

	//initialize the selection status. initially none of the entries are being selected
	$("#col_select").data('full_selection',0);

	//open the dialog when the delete user link clicked
	$("#user_delete").on('click',function(){
		
		var selected_entries_total = $("#entries_table input[type='checkbox']:not('#col_select'):checked").length;

		if(selected_entries_total > 0){
			//customize the message for the entry deletion dialog box
			var delete_button_text = '';
			var delete_message = '';

			if($("#col_select").data('full_selection') == 1){ //if all entries selected
				
				if($("#filter_info").length > 0){
					delete_message		= "The selected users will be deleted.";
					delete_button_text 	= "Yes. Delete selected users";
				}else{
					delete_message	   = "<span style='font-size: 125%'>ALL users</span> (except Main Administrator) will be deleted.";
					delete_button_text = "Yes. Delete all users";
				}
			}else{
				//if one entry selected
				if(selected_entries_total == 1){
					var temp = $("#entries_table input[type='checkbox']:not('#col_select'):checked").attr("id").split("_");
					
					delete_message	   = "The user with <span style='font-size: 125%'>ID #" + temp[1] + "</span> will be deleted.";
					delete_button_text = "Yes. Delete user #" + temp[1];
				}else{ //if few entries being selected
					delete_message	   = "The selected <span style='font-size: 125%'>" + selected_entries_total + " users</span> will be deleted.";
					delete_button_text = "Yes. Delete selected users";
				}
			}

			var csrf_token  = $("#entries_options").data("csrftoken");
			var selected_checkboxes = $("#entries_table input[type='checkbox']:not('#col_select'):checked").serializeArray();

			Swal.fire({
				title: 'Are you sure you want to proceed with the deletion?',
				html: delete_message,
				footer: 'This action cannot be undone.',
				icon: 'warning',
				width: '40%',
				customClass: {
					htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
					footer: 'swal2-footer-warning',
					title: 'swal2-title-warning'
				},
				showCancelButton: true,
				confirmButtonText: delete_button_text,
				showLoaderOnConfirm: true,
				preConfirm: () => {
					return axios.post('change_user_status.php', {
						action: 'delete',
						csrf_token: csrf_token,
						delete_all: $("#col_select").data('full_selection'),
						selected_users: selected_checkboxes
					})
					.then(function (response) {
						if(response.data.status == 'ok'){
							return response;
						}else{
							Swal.showValidationMessage('Error: Unable to process. Please try again later.');
						}
					})
					.catch(function (error) {
						Swal.showValidationMessage("Error: " + error);
					})
				},
				allowOutsideClick: () => !Swal.isLoading()
			}).then((result) => {
				if(result.isConfirmed) {
					//redirect to user manager
					window.location.replace('manage_users.php');
				}
			});
		}else{
			Swal.fire({
				title: 'No user selected',
				html: `You have not chosen any users! <br/>Please select a minimum of one user for deletion.`,
				customClass: {
					title: 'swal2-title-warning',
					htmlContainer: 'swal2-html-container-bold'
				},
				icon: 'error',
				width: '30%',
				allowOutsideClick: true
			});
		}
		
		return false;
	});

	//open the suspend confirmation dialog when the suspend link being clicked
	$("#user_suspend").on('click',function(){
		var selected_entries_total = $("#entries_table input[type='checkbox']:not('#col_select'):checked").length;

		if(selected_entries_total > 0){
			//customize the message for the entry deletion dialog box
			var suspend_button_text = '';
			var suspend_message = '';

			if($("#col_select").data('full_selection') == 1){ //if all entries selected
				
				if($("#filter_info").length > 0){
					suspend_message		= "The selected users will be suspended.";
					suspend_button_text = "Yes. Suspend selected users";
				}else{
					suspend_message		= "<span style='font-size: 125%'>ALL users</span> (except Main Administrator) will be suspended.";
					suspend_button_text = "Yes. Suspend all users";
				}
			}else{
				//if one entry selected
				if(selected_entries_total == 1){
					var temp = $("#entries_table input[type='checkbox']:not('#col_select'):checked").attr("id").split("_");

					suspend_message	    = "The user with <span style='font-size: 125%'>ID #" + temp[1] + "</span> will be suspended.";
					suspend_button_text = "Yes. Suspend user #" + temp[1];
				}else{ //if few entries being selected
					suspend_message	    = "The selected <span style='font-size: 125%'>" + selected_entries_total + " users</span> will be suspended.";
					suspend_button_text = "Yes. Suspend selected users";
				}
			}

			var csrf_token  = $("#entries_options").data("csrftoken");
			var selected_checkboxes = $("#entries_table input[type='checkbox']:not('#col_select'):checked").serializeArray();

			Swal.fire({
				title: 'Are you sure you want to suspend the selected user(s)?',
				html: suspend_message,
				footer: 'The user(s) will be suspended and will no longer be able to log in.',
				icon: 'warning',
				width: '40%',
				customClass: {
					htmlContainer: 'swal2-html-container-bold swal2-html-container-padding-bottom',
					footer: 'swal2-footer-warning',
					title: 'swal2-title-warning'
				},
				showCancelButton: true,
				confirmButtonText: suspend_button_text,
				showLoaderOnConfirm: true,
				preConfirm: () => {
					return axios.post('change_user_status.php', {
						action: 'suspend',
						csrf_token: csrf_token,
						delete_all: $("#col_select").data('full_selection'),
						selected_users: selected_checkboxes
					})
					.then(function (response) {
						if(response.data.status == 'ok'){
							return response;
						}else{
							Swal.showValidationMessage('Error: Unable to process. Please try again later.');
						}
					})
					.catch(function (error) {
						Swal.showValidationMessage("Error: " + error);
					})
				},
				allowOutsideClick: () => !Swal.isLoading()
			}).then((result) => {
				if(result.isConfirmed) {
					//redirect to user manager
					window.location.replace('manage_users.php');
				}
			});
		}else{
			Swal.fire({
				title: 'No user selected',
				html: `You have not chosen any users! <br/>Please select a minimum of one user for suspension.`,
				customClass: {
					title: 'swal2-title-warning',
					htmlContainer: 'swal2-html-container-bold'
				},
				icon: 'error',
				width: '30%',
				allowOutsideClick: true
			});
		}
		
		return false;
	});
	

	$("#entries_table tbody td:not('.me_action')").on('click',function(){
		var temp = $(this).parent().attr("id").split("_");
		var selected_user_id = temp[1];

		window.location.href = 'view_user.php?id=' + selected_user_id;
	});

});